<?php

namespace App\Http\Controllers;

use App\Http\Requests\ChangePasswordRequest;
use App\Http\Requests\StoreAdminRequest;
use App\Http\Requests\UpdateAdminRequest;
use App\Models\Admin;
use App\Services\AdminService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Spatie\Permission\Models\Role;

class AdminController extends Controller
{
    public function __construct()
    {
        $this->admins = Admin::all();
        $this->roles = Role::all();
    }

    public function index()
    {
        return view('backoffice/superadmin/admins/index', ['admins' => $this->admins]);
    }

//    public function show()
//    {
//        return view('backoffice/profile');
//    }

    public function create()
    {
        return view('backoffice/superadmin/admins/create', ['roles' => $this->roles]);
    }

    public function store(StoreAdminRequest $request, AdminService $service)
    {
        $admin = $service->storeAdmin($request);

        Session::flash('success', 'Uspešno ste kreirali administratora: '.$admin->fullName());
        return redirect('backoffice/admins/');
    }

    public function edit(Admin $admin)
    {
        return view('backoffice/superadmin/admins/edit', ['admin' => $admin]);
    }

    public function update(UpdateAdminRequest $request, Admin $admin, AdminService $service)
    {
        $admin = $service->updateAdmin($admin, $request);

        Session::flash('success', 'Uspešno ste izmenili administratora: '.$admin->fullName());
        return redirect('backoffice/admins/');
    }

    public function destroy(Admin $admin)
    {
        try {
            $admin->delete();
        } catch (\Exception $exception) {
            Session::flash('error', 'Niste uspeli da obrišete administratora: '.$admin->fullName());
            return redirect('backoffice/admins/');
        }

        Session::flash('success', 'Uspešno ste obrisali administratora: '.$admin->fullName());
        return redirect('backoffice/admins/');
    }

    public function changePassword(ChangePasswordRequest $request)
    {
        Auth::user()->update($request->validated());

        Session::flash('success', 'Uspešno ste promenili vašu lozinku');
        return redirect('backoffice/');

    }
}
