<?php

namespace App\Http\Controllers;

use App\Traits\ImageTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class GalleryController extends Controller
{
    use ImageTrait;

    public function index()
    {
        $folders = array_map('basename', Storage::directories('public/images/gallery'));
//        dd($folders);

        return view('backoffice/superadmin/gallery/index', ['folders' => $folders]);
    }

    public function show($folder)
    {
        $files = array_map('basename', Storage::files('public/images/gallery/' . $folder));

        return view('backoffice/superadmin/gallery/folder/show', ['folder' => $folder, 'files' => $files]);
    }

    public function create(Request $request)
    {
        //
    }

    public function storeFolder(Request $request)
    {
        Storage::makeDirectory('public/images/gallery/' . $request->folder_name);

        Session::flash('success', 'Uspešno ste kreirali novi folder');
        return redirect('backoffice/gallery');
    }

    public function createFile(Request $request)
    {
        //
    }

    public function storeFile(Request $request)
    {
        if ($request->has('images')) {
            foreach ($request->file('images') as $image) {
                $this->storeImage('gallery/' . $request->folder, $image);
            }
        }

        Session::flash('success', 'Uspešno ste dodali slike');
        return redirect('backoffice/gallery');
    }

    public function destroyFolder($folder)
    {
        $pathToFiles = Storage::path('public\images\gallery\\' . $folder.'\\*');
        $pathToFolder = Storage::path('public\images\gallery\\' . $folder);
        //php (Laravel way doesn't work)
        $files = glob($pathToFiles);
        foreach ($files as $file) {
            if ($file) {
                unlink($file);
            }
        }
        rmdir($pathToFolder);
//        Storage::deleteDirectory($path);

        Session::flash('success', 'Uspešno ste obrisali album');
        return redirect('backoffice/gallery');
    }

    public function destroyFile($folder, $file)
    {
        $path = Storage::path('public\images\gallery\\' . $folder . '\\' . $file);
        //php (Laravel way doesn't work)
        unlink($path);
//        Storage::delete($path);

        Session::flash('success', 'Uspešno ste obrisali sliku');
        return redirect('backoffice/gallery/folder/' . $folder);
    }
}
