<?php

namespace App\Http\Controllers;

use App\Http\Requests\UpdateNewsRequest;
use App\Services\NewsService;
use App\Http\Requests\StoreNewsRequest;
use App\Models\News;
use Illuminate\Support\Facades\Session;

class NewsController extends Controller
{
    public function __construct()
    {
        $this->news = News::orderByDesc('pinned')->get();
    }

    public function index()
    {
        return view('backoffice/superadmin/news/index', ['news' => $this->news]);
    }

    public function show()
    {
        //
    }

    public function create()
    {
        return view('backoffice/superadmin/news/create');
    }

    public function store(StoreNewsRequest $request, NewsService $service)
    {
        $service->storeNews($request);

        Session::flash('success', 'Uspešno ste objavili vest');
        return redirect('backoffice/news/');
    }

    public function edit(News $news)
    {
        return view('backoffice/superadmin/news/edit', ['news' => $news]);
    }

    public function update(UpdateNewsRequest $request, News $news, NewsService $service)
    {
        $service->updateNews($news, $request);

        Session::flash('success', 'Uspešno ste izmenili vest');
        return redirect('backoffice/news/');
    }

    public function destroy(News $news)
    {
        try {
            $news->delete();
        } catch (\Exception $exception) {
            Session::flash('error', 'Niste uspeli da obrišete vest');
            return redirect('backoffice/news/');
        }

        Session::flash('success', 'Uspešno ste obrisali vest');
        return redirect('backoffice/news/');
    }

    public function pin(News $news)
    {
        //
    }
}
