<?php

namespace App\Http\Controllers;

use App\Http\Requests\StorePlayerRequest;
use App\Http\Requests\UpdatePlayerRequest;
use App\Models\Player;
use App\Models\Team;
use App\Services\PlayerService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class PlayerController extends Controller
{
    public function index()
    {
        $teams = Team::where('club_id', Auth::user()->club_id)->pluck('id');
        $players = Player::whereIn('team_id', $teams)->get();

        return view('backoffice/coach/players/index', ['players' => $players]);
    }

    public function create()
    {
        $teams = Team::where('club_id', Auth::user()->club_id)->get();

        return view('backoffice/coach/players/create', ['teams' => $teams]);
    }

    public function store(StorePlayerRequest $request, PlayerService $service)
    {
        $player = $service->storePlayer($request);

        Session::flash('success', 'Uspešno ste kreirali igrača: '.$player->fullName());
        return redirect('backoffice/players/');
    }

    public function edit(Player $player)
    {
        $teams = Team::where('club_id', Auth::user()->club_id)
            ->where('id', '!=', $player->team_id)
            ->get();

        return view('backoffice/coach/players/edit', ['player' => $player, 'teams' => $teams]);
    }

    public function update(UpdatePlayerRequest $request, Player $player, PlayerService $service)
    {
        $player = $service->updatePlayer($request, $player);

        Session::flash('success', 'Uspešno ste izmenili igrača: '.$player->fullName());
        return redirect('backoffice/players/');
    }

    public function destroy(Player $player)
    {
        try {
            $player->delete();
        } catch (\Exception $exception) {
            Session::flash('error', 'Niste uspeli da obrišete igrača: '.$player->fullName());
            return redirect('backoffice/news/');
        }

        Session::flash('success', 'Uspešno ste obrisali igrača: '.$player->fullName());
        return redirect('backoffice/players/');
    }
}
