<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreSponsorRequest;
use App\Http\Requests\UpdateSponsorRequest;
use App\Models\Sponsor;
use App\Services\SponsorService;
use Illuminate\Support\Facades\Session;

class SponsorController extends Controller
{
    public function __construct()
    {
        $this->sponsors = Sponsor::all();
    }

    public function index()
    {
        return view('backoffice/superadmin/sponsors/index', ['sponsors' => $this->sponsors]);
    }

    public function show()
    {
        //
    }

    public function create()
    {
        return view('backoffice/superadmin/sponsors/create');
    }

    public function store(StoreSponsorRequest $request, SponsorService $service)
    {
        $sponsor = $service->storeSponsor($request);

        Session::flash('success', 'Uspešno ste kreirali sponzora: '.$sponsor->name);
        return redirect('backoffice/sponsors/');
    }

    public function edit(Sponsor $sponsor)
    {
        return view('backoffice/superadmin/sponsors/edit', ['sponsor' => $sponsor]);
    }

    public function update(UpdateSponsorRequest $request, Sponsor $sponsor, SponsorService $service)
    {
        $sponsor = $service->updateSponsor($sponsor, $request);

        Session::flash('success', 'Uspešno ste izmenili sponzora: '.$sponsor->name);
        return redirect('backoffice/sponsors/');
    }

    public function destroy(Sponsor $sponsor)
    {
        try {
            $sponsor->delete();
        } catch (\Exception $exception) {
            Session::flash('error', 'Niste uspeli da obrišete sponzora: '.$sponsor->name);
            return redirect('backoffice/sponsors/');
        }

        Session::flash('success', 'Uspešno ste obrisali sponzora: '.$sponsor->name);
        return redirect('backoffice/sponsors/');
    }
}
