<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreTeamRequest;
use App\Http\Requests\UpdateTeamRequest;
use App\Models\Admin;
use App\Models\Team;
use App\Services\TeamService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class TeamController extends Controller
{
    public function index()
    {
        return view('backoffice/coach/teams/index', ['teams' => Team::where('club_id', Auth::user()->club_id)->get()]);
    }

    public function create()
    {
        $coaches = Admin::where('club_id', Auth::user()->club_id)->get();

        return view('backoffice/coach/teams/create', ['coaches' => $coaches]);
    }

    public function store(StoreTeamRequest $request, TeamService $service)
    {
        $team = $service->storeTeam($request);

        Session::flash('success', 'Uspešno ste kreirali tim: '.$team->name);
        return redirect('backoffice/teams/');
    }

    public function edit(Team $team)
    {
        $coaches = Admin::where('id', '!=', $team->coach_id)->where('club_id', Auth::user()->club_id)->get();

        return view('backoffice/coach/teams/edit', ['team' => $team, 'coaches' => $coaches]);
    }

    public function update(UpdateTeamRequest $request, Team $team, TeamService $service)
    {
        $team = $service->updateTeam($request, $team);

        Session::flash('success', 'Uspešno ste izmenili tim: '.$team->name);
        return redirect('backoffice/teams/');
    }

    public function destroy(Team $team)
    {
        try {
            $team->delete();
        } catch (\Exception $exception) {
            Session::flash('error', 'Niste uspeli da obrišete tim: '.$team->name);
            return redirect('backoffice/teams/');
        }

        Session::flash('success', 'Uspešno ste obrisali tim: '.$team->name);
        return redirect('backoffice/teams/');
    }
}
