<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class GalleryController extends Controller
{
    public function index()
    {
        $folders = array_map('basename', Storage::directories('public/images/gallery'));
        $folder_covers = [];
        foreach ($folders as $folder){
            if(array_map('basename', Storage::files('public/images/gallery/' . $folder)) != null){
                $folder_covers[] = 'storage/images/gallery/' . $folder .  '/'  . array_map('basename', Storage::files('public/images/gallery/' . $folder))[0];
            }
            else{
                $index = array_search($folder, $folders);
                unset($folders[$index]);
            }
        }
        $folders = array_combine($folders, $folder_covers);

        return view('website/gallery/gallery', ['folders' => $folders]);
    }

    public function album($folder){
        $pictures = array_map('basename', Storage::files('public/images/gallery/' . $folder));

        return view('website/gallery/album', ['folder' => $folder, 'pictures' => $pictures]);
    }
}
