<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\News;
use App\Models\Sponsor;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $news = News::all()->sortDesc()->take(4);
        $latestNews = $news->take(2);
        $olderNews = $news->slice(2);

        return view('website/home', ['latestNews' => $latestNews, 'olderNews' => $olderNews]);
    }

    public function test(){
        return view('website/test');
    }
}
