<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ContactMessageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        /**
         * Get the validation rules that apply to the request.
         *
         * @return array<string, mixed>
         */
        return [
            //message
            'email' => 'required|email',
            'title' => 'nullable|string|min:1|max:50',
            'message' => 'required|string|min:1',
        ];
    }
}
