<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreClubCoachRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            //club
            'name' => 'required|string|min:2|max:255',
            'address' => 'required|string|min:2|max:255',
            'logo' => 'nullable|image',
            'email' => 'nullable|email|unique:clubs',
            'website' => 'nullable|string|starts_with:http',
            'phone' => 'nullable|string|regex:/(^[0-9+() ]+$)/',
            //coach (admin)
            'first_name' => 'required|string|min:2|max:255',
            'last_name' => 'required|string|min:2|max:255',
            'coach_email' => 'required|email|unique:admins,email',
            'password' => 'required|string|confirmed',
        ];
    }
}
