<?php

namespace App\Http\View\Composers;

use App\Models\Competition;
use App\Models\Sponsor;
use Illuminate\View\View;

class NavbarComposer
{
    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $competitions = Competition::all();
        $sponsors = Sponsor::all();

        $view->with('competitions', $competitions)->with('sponsors', $sponsors);
    }
}
