<?php

namespace App\Main;

use Illuminate\Support\Facades\Auth;

class SideMenu
{
    /**
     * List of side menu items.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public static function menu()
    {
        $admin = Auth::user();
        if ($admin) {
            if ($admin->hasRole('Superadministrator')) {
                return [
                    'dashboard' => [
                        'iconfo' => 'fas fa-home',
                        'icon' => 'home',
                        'title' => 'Početna',
                        'route_name' => 'dashboard',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                    'admins' => [
                        'iconfo' => 'fas fa-user',
                        'icon' => 'user',
                        'title' => 'Administratori',
                        'route_name' => 'admins.index',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                    'devider',
                    'competitions' => [
                        'iconfo' => 'fas fa-dollar-sign',
                        'icon' => 'octagon',
                        'title' => 'Takmičenja',
                        'route_name' => 'competitions.index',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                    'clubs' => [
                        'iconfo' => 'fas fa-dollar-sign',
                        'icon' => 'octagon',
                        'title' => 'Klubovi',
                        'route_name' => 'clubs.index',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                    'devider',
                    'news' => [
                        'iconfo' => 'fas fa-newspaper',
                        'icon' => 'paperclip',
                        'title' => 'Vesti',
                        'route_name' => 'news.index',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                    'gallery' => [
                        'iconfo' => 'fas fa-newspaper',
                        'icon' => 'paperclip',
                        'title' => 'Galerija',
                        'route_name' => 'gallery.index',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                    'sponsors' => [
                        'iconfo' => 'fas fa-dollar-sign',
                        'icon' => 'paperclip',
                        'title' => 'Sponzori',
                        'route_name' => 'sponsors.index',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                ];
            } elseif ($admin->hasRole('Administrator')) {
                return [
                    'dashboard' => [
                        'iconfo' => 'fas fa-home',
                        'icon' => 'home',
                        'title' => 'AdministratorDashboard',
                        'route_name' => 'dashboard',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                    'news' => [
                        'iconfo' => 'fas fa-newspaper',
                        'icon' => 'paperclip',
                        'title' => 'Vesti',
                        'route_name' => 'news.index',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                    'sponsors' => [
                        'iconfo' => 'fas fa-dollar-sign',
                        'icon' => 'octagon',
                        'title' => 'Sponzori',
                        'route_name' => 'sponsors.index',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                ];
            } elseif ($admin->hasRole('Referee')) {
                return [
                    'dashboard' => [
                        'iconfo' => 'fas fa-home',
                        'icon' => 'home',
                        'title' => 'RefereeDashboard',
                        'route_name' => 'dashboard',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                ];
            } elseif ($admin->hasRole('Coach')) {
                return [
                    'dashboard' => [
                        'iconfo' => 'fas fa-home',
                        'icon' => 'home',
                        'title' => 'Početna',
                        'route_name' => 'dashboard',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                    'devider',
                    'teams' => [
                        'iconfo' => 'fas fa-dollar-sign',
                        'icon' => 'octagon',
                        'title' => 'Timovi',
                        'route_name' => 'teams.index',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                    'players' => [
                        'iconfo' => 'fas fa-dollar-sign',
                        'icon' => 'octagon',
                        'title' => 'Igrači',
                        'route_name' => 'players.index',
                        'params' => [
                            'layout' => 'side-menu',
                        ],
                    ],
                ];
            }
        }
        return [];
    }
}
