<?php

namespace App\Main;

use Illuminate\Support\Facades\Auth;

class SimpleMenu
{
    public static function menu()
    {
        $admin = Auth::user();
        if ($admin) {
            if ($admin->hasRole('Superadministrator')) {
                return [
                    'dashboard' => [
                        'iconfo' => 'fas fa-home',
                        'icon' => 'home',
                        'title' => 'Početna',
                        'route_name' => 'dashboard',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                    'admins' => [
                        'iconfo' => 'fas fa-user',
                        'icon' => 'user',
                        'title' => 'Administratori',
                        'route_name' => 'admins.index',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                    'devider',
                    'competitions' => [
                        'iconfo' => 'fas fa-dollar-sign',
                        'icon' => 'octagon',
                        'title' => 'Takmičenja',
                        'route_name' => 'competitions.index',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                    'clubs' => [
                        'iconfo' => 'fas fa-dollar-sign',
                        'icon' => 'octagon',
                        'title' => 'Klubovi',
                        'route_name' => 'clubs.index',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                    'devider',
                    'news' => [
                        'iconfo' => 'fas fa-newspaper',
                        'icon' => 'paperclip',
                        'title' => 'Vesti',
                        'route_name' => 'news.index',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                    'gallery' => [
                        'iconfo' => 'fas fa-newspaper',
                        'icon' => 'paperclip',
                        'title' => 'Galerija',
                        'route_name' => 'gallery.index',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                    'sponsors' => [
                        'iconfo' => 'fas fa-dollar-sign',
                        'icon' => 'octagon',
                        'title' => 'Sponzori',
                        'route_name' => 'sponsors.index',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                ];
            } elseif ($admin->hasRole('Administrator')) {
                return [
                    'dashboard' => [
                        'iconfo' => 'fas fa-home',
                        'icon' => 'home',
                        'title' => 'AdministratorDashboard',
                        'route_name' => 'dashboard',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                    'news' => [
                        'iconfo' => 'fas fa-newspaper',
                        'icon' => 'paperclip',
                        'title' => 'Vesti',
                        'route_name' => 'news.index',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                    'sponsors' => [
                        'iconfo' => 'fas fa-dollar-sign',
                        'icon' => 'paperclip',
                        'title' => 'Sponzori',
                        'route_name' => 'sponsors.index',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                ];
            } elseif ($admin->hasRole('Referee')) {
                return [
                    'dashboard' => [
                        'iconfo' => 'fas fa-home',
                        'icon' => 'home',
                        'title' => 'RefereeDashboard',
                        'route_name' => 'dashboard',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                ];
            } elseif ($admin->hasRole('Coach')) {
                return [
                    'dashboard' => [
                        'iconfo' => 'fas fa-home',
                        'icon' => 'home',
                        'title' => 'Početna',
                        'route_name' => 'dashboard',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                    'devider',
                    'teams' => [
                        'iconfo' => 'fas fa-dollar-sign',
                        'icon' => 'octagon',
                        'title' => 'Timovi',
                        'route_name' => 'teams.index',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                    'players' => [
                        'iconfo' => 'fas fa-dollar-sign',
                        'icon' => 'octagon',
                        'title' => 'Igrači',
                        'route_name' => 'players.index',
                        'params' => [
                            'layout' => 'simple-menu',
                        ],
                    ],
                ];
            }
        }
        return [];
    }
}
