<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Competition extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'description', 'starts_at', 'competition_template_id'
    ];

    public function competitionTemplate() : BelongsTo
    {
        return $this->belongsTo(CompetitionTemplate::class);
    }

    public function group() : HasMany
    {
        return $this->hasMany(Group::class);
    }

    //Accessors & Mutators

    public function startsAt(): Attribute
    {
        return new Attribute(
            get: fn($value) => Carbon::parse($value)->toFormattedDateString(),
            set: fn($value) => Carbon::parse($value)->toDateString()
        );
    }
}
