<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CompetitionTemplate extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'logo', 'competition_type_id'
    ];

    public function competitionType(): BelongsTo
    {
        return $this->belongsTo(CompetitionType::class);
    }

    public function leagues()
    {
        return $this::whereHas('competitionType', function ($query) {
            $query->where('name', 'League');
        })->get();
    }

    public function cups()
    {
        return $this::whereHas('competitionType', function ($query) {
            $query->where('name', 'Cup');
        })->get();
    }
}
