<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class GameTime extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'starts_at',
        'ends_at',
        'playground_id',
        'age_limit_id',
        'fixture_id'
    ];

    protected $with = [
        'ageLimit',
        'playground'
    ];

    public function ageLimit() : BelongsTo
    {
        return $this->belongsTo(AgeLimit::class);
    }

    public function playground() : BelongsTo
    {
        return $this->belongsTo(Playground::class);
    }
}
