<?php

namespace App\Services;

use App\Http\Requests\StoreAdminRequest;
use App\Http\Requests\UpdateAdminRequest;
use App\Models\Admin;
use App\Traits\ImageTrait;

class AdminService
{
    use ImageTrait;

    public function storeAdmin(StoreAdminRequest $request)
    {
        $admin = Admin::create($request->validated());
        $this->storeAdminImage($admin, $request->image);
        $admin->assignRole($request->role);

        return $admin;
    }

    public function updateAdmin(Admin $admin, UpdateAdminRequest $request): Admin
    {
        $admin->update($request->validated());
        $this->storeAdminImage($admin, $request->image);
        $admin->assignRole($request->role);

        return $admin;
    }

    public function storeAdminImage(Admin $admin, $image)
    {
        if ($image) {
            $admin->image = $this->storeImage('admins/' . $admin->id . '/', $image);
            $admin->save();
        }
    }
}
