<?php

namespace App\Services;

use App\Http\Requests\StoreAdminRequest;
use App\Http\Requests\StoreClubCoachRequest;
use App\Http\Requests\StoreClubRequest;
use App\Http\Requests\UpdateClubRequest;
use App\Mail\ClubSignedUp;
use App\Models\Admin;
use App\Models\Club;
use App\Traits\ImageTrait;
use Illuminate\Support\Facades\Mail;

class ClubService
{
    use ImageTrait;

    public function storeClub(StoreClubCoachRequest $request): Club
    {
        $club = Club::create($request->validated());
        $this->storeClubLogo($club, $request->logo);
        $coach = $this->storeCoach($request, $club);
        //sklonjeno za sada sa lajva
//        Mail::to($coach->email)->send(new ClubSignedUp($coach->email));

        return $club;
    }

    public function updateClub(UpdateClubRequest $request, Club $club): Club
    {
        $club->update($request->validated());
        $this->storeClubLogo($club, $request->logo);

        return $club;
    }

    public function storeCoach(StoreClubCoachRequest $request, Club $club): Admin
    {
        $coach = Admin::create([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->coach_email,
            'password' => $request->password,
            'club_id' => $club->id
        ]);
        $coach->assignRole('Coach');

        return $coach;
    }

    public function storeClubLogo(Club $club, $logo)
    {
        if ($logo) {
            $club->logo = $this->storeImage('clubs/' . $club->id . '/', $logo);
            $club->save();
        }
    }
}
