<?php

namespace App\Services;

use App\Http\Requests\StoreCompetitionRequest;
use App\Http\Requests\UpdateCompetitionRequest;
use App\Models\Competition;
use App\Traits\ImageTrait;

class CompetitionService
{
    use ImageTrait;

    public function storeCompetition(StoreCompetitionRequest $request)
    {
        $competition = Competition::create($request->validated());

        return $competition;
    }

    public function updateCompetition(UpdateCompetitionRequest $request, Competition $competition)
    {
        $competition->update($request->validated());

        return $competition;
    }
}
