<?php

namespace App\Services;

use App\Http\Requests\StoreNewsRequest;
use App\Http\Requests\UpdateNewsRequest;
use App\Models\News;
use App\Traits\ImageTrait;
use Illuminate\Http\Request;

class NewsService
{
    use ImageTrait;

    public function storeNews(StoreNewsRequest $request)
    {
        $news = News::create($request->validated());
        $this->storeNewsImage($news, $request->image);

        return $news;
    }

    public function updateNews(News $news, UpdateNewsRequest $request): News
    {
        $news->update($request->validated());
        $this->storeNewsImage($news, $request->image);

        return $news;
    }

    public function storeNewsImage(News $news, $image = null)
    {
        if ($image) {
            $news->image = $this->storeImage('news/' . $news->id . '/', $image);
            $news->save();
        }
    }
}
