<?php

namespace App\Services;

use App\Http\Requests\StorePlayerRequest;
use App\Http\Requests\UpdatePlayerRequest;
use App\Models\Player;
use App\Traits\ImageTrait;

class PlayerService
{
    use ImageTrait;

    public function storePlayer(StorePlayerRequest $request) : Player
    {
        $player = Player::create($request->validated());
        $this->storePlayerImage($player, $request->image);

        return $player;
    }

    public function updatePlayer(UpdatePlayerRequest $request, Player $player): Player
    {
        $player->update($request->validated());
        $this->storePlayerImage($player, $request->image);

        return $player;
    }

    public function storePlayerImage(Player $player, $image)
    {
        if ($image) {
            $player->image = $this->storeImage('players/' . $player->id . '/', $image);
            $player->save();
        }

    }
}
