<?php

use App\Models\CompetitionTemplate;
use App\Models\CompetitionType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('competitions', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->default('Description for Competition');
            $table->timestamp('starts_at')->default('2022-09-01 00:00:00');
            $table->foreignIdFor(CompetitionTemplate::class)->constrained();
            $table->timestamps();
        });

        Artisan::call('db:seed', [
            '--class' => 'CompetitionSeeder'
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('competitions');
    }
};
