<?php

namespace Database\Seeders;

use App\Models\AgeLimit;
use App\Models\FieldVariant;
use Illuminate\Database\Seeder;

class AgeLimitFieldVariantSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $fieldVariants = FieldVariant::all();
        $ageLimits = AgeLimit::all();
        //Variant 1
        $fieldVariants[0]->ageLimits()->attach($ageLimits[0], ['number_of_fields' => 4]);
        $fieldVariants[0]->ageLimits()->attach($ageLimits[1], ['number_of_fields' => 4]);
        $fieldVariants[0]->ageLimits()->attach($ageLimits[5], ['number_of_fields' => 1]);
        //Variant 2
        $fieldVariants[1]->ageLimits()->attach($ageLimits[4], ['number_of_fields' => 3]);
        //Variant 3
        $fieldVariants[2]->ageLimits()->attach($ageLimits[3], ['number_of_fields' => 2]);
        $fieldVariants[2]->ageLimits()->attach($ageLimits[5], ['number_of_fields' => 1]);
        //Variant 4
        $fieldVariants[3]->ageLimits()->attach($ageLimits[3], ['number_of_fields' => 2]);
        $fieldVariants[3]->ageLimits()->attach($ageLimits[2], ['number_of_fields' => 2]);
        //Variant 5
        $fieldVariants[4]->ageLimits()->attach($ageLimits[4], ['number_of_fields' => 1]);
        $fieldVariants[4]->ageLimits()->attach($ageLimits[1], ['number_of_fields' => 2]);
        $fieldVariants[4]->ageLimits()->attach($ageLimits[5], ['number_of_fields' => 1]);
    }
}
