<?php

namespace Database\Seeders;

use App\Faker;
use App\Models\News;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class NewsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $news = Faker::fakeNews();

        foreach ($news as $n)
        {
            News::create([
                'title' => $n['title'],
                'short_content' => $n['short_content'],
                'article_content' => $n['content']
            ]);
        }
    }
}
