<?php

namespace Database\Seeders;

use App\Faker;
use App\Models\Sponsor;
use Faker\Provider\Lorem;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SponsorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $sponsors = Faker::fakeFoods();

        foreach ($sponsors as $sponsor) {
            Sponsor::create([
                'name' => $sponsor['name'],
                'description' => Lorem::paragraph(1, false),
                'logo' => $sponsor['image']
            ]);
        }
    }
}
