@extends('../layouts/' . $layout)

@section('subhead')
    <title>Kreiranje Igrača - Fairplay</title>
@endsection

@section('subcontent')
    <!-- BEGIN: Wizard Layout -->
    <div class="intro-y box py-10 sm:py-20 mt-5">
        <!-- BEGIN: Form Layout -->
        <form action="{{route('players.store')}}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="intro-y box p-5">
                <div class="grid grid-cols-8">
                    <div class="col-span-3 p-10">
                        <input id="imageFile" type="file" name="image" placeholder="Izaberite sliku igrača" hidden>
                        <img src="{{asset('storage/images/players/default.png')}}" alt="" id="imageInput"
                             style="cursor:pointer; object-fit: contain; height: 200px; width: 200px;">
                    </div>
                    <div class="col-span-5">
                        <div class="mt-5">
                            <label for="crud-form-2" class="form-label">Ime</label>
                            <input id="crud-form-2" type="text" name="first_name" class="form-control"
                                   maxlength="100"
                                   placeholder="Unesite ime igrača" autofocus required value="{{old('first_name')}}">
                        </div>

                        <div class="mt-5">
                            <label for="crud-form-3" class="form-label">Last Name</label>
                            <input id="crud-form-3" type="text" name="last_name" class="form-control"
                                   maxlength="100"
                                   placeholder="Unesite prezime igrača" autofocus required value="{{old('last_name')}}">
                        </div>
                        <div class="mt-5">
                            <label for="crud-form-4" class="form-label">Datum rođenja</label>
                            <input id="crud-form-4" type="date" name="date_of_birth" class="form-control"
                                   placeholder="Unesite datum rođenja" autofocus required
                                   value="{{old('date_of_birth')}}">
                        </div>
                    </div>
                </div>

                <div class="mt-3 grid grid-cols-2 gap-3">
                    <label for="crud-form-5" class="form-label">Tim</label>
                    <label for="crud-form-6" class="form-label">Broj dresa</label>
                </div>
                <div class="grid grid-cols-2 gap-3">
                    <div class="input-group">
                        <select data-placeholder="Izaberi tim igrača" class="tom-select w-full"
                                name="team_id" id="crud-form-6">
                            @foreach($teams as $team)
                                <option value="{{$team->id}}">{{$team->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="input-group">
                        <input id="crud-form-6" type="number" name="jersey_number" class="form-control"
                               placeholder="Unesite broj na dresu igrača" autofocus required
                               value="{{old('jersey_number')}}">
                    </div>
                </div>
                <div class="mt-3 grid grid-cols-2 gap-3">
                    <label for="crud-form-5" class="form-label">Visina</label>
                    <label for="crud-form-6" class="form-label">Kilaža</label>
                </div>
                <div class="grid grid-cols-2 gap-3">
                    <div class="input-group">
                        <input id="crud-form-5" type="number" name="height" class="form-control" maxlength="100"
                               placeholder="Unesite visinu igrača" autofocus required value="{{old('height')}}">
                    </div>

                    <div class="input-group">
                        <input id="crud-form-6" type="number" name="weight" class="form-control" maxlength="100"
                               placeholder="Unesite kilažu igrača" autofocus required value="{{old('weight')}}">
                    </div>
                </div>
                <div class="text-right mt-5">
                    <div class="intro-y col-span-12 flex items-center justify-center sm:justify-end mt-5">
                        <button type="submit" class="btn btn-primary btn-wizard-next-1 w-24 ml-2">Kreiraj</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('script')
    <script src="{{ asset('js/single-image-upload.js') }}"></script>
@endsection
