@extends('../layouts/' . $layout)

@section('subhead')
    <title>Igrači - Fairplay</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 flex flex-wrap sm:flex-nowrap items-center mt-2">

            <div class="hidden md:block mx-auto text-gray-600"></div>
            <a href="{{route('players.create')}}" class="btn btn-primary shadow-md mr-2">Dodaj novog igrača</a>

            {{--            <div class="w-full sm:w-auto mt-3 sm:mt-0 sm:ml-auto md:ml-0">--}}
{{--                <div class="w-56 relative text-gray-700 dark:text-gray-300">--}}
{{--                    <input type="text" class="form-control w-56 box pr-10 placeholder-theme-13"--}}
{{--                           placeholder="Pretraga...">--}}
{{--                    <i class="w-4 h-4 absolute my-auto inset-y-0 mr-3 right-0" data-feather="search"></i>--}}
{{--                </div>--}}
{{--            </div>--}}
        </div>
        <!-- BEGIN: Users Layout -->
        @foreach ($players as $player)
            <div class="intro-y col-span-12 md:col-span-6">
                <div class="box">
                    <div class="flex flex-col lg:flex-row items-center p-5">
                        <div class="w-24 h-24 lg:w-12 lg:h-12 image-fit lg:mr-1">
                            <img @if($player->image == 'default.png')
                                 src="{{asset('storage/images/players/'.$player->image)}}"
                                 @else
                                 src="{{'storage/images/players/'.$player->id.'/'.$player->image}}"
                                 @endif alt="Slika Igrača">
                        </div>
                        <div class="lg:ml-2 lg:mr-auto text-center lg:text-left mt-3 lg:mt-0">
                            <div class="font-medium">{{ $player->fullName() }}</div>
                            <div class="text-gray-600 text-xs mt-0.5">{{ $player->team->name }}</div>
                        </div>
                        <div class="flex mt-4 lg:mt-0">
                            <a href="{{route('players.edit', ['player' => $player])}}" class="btn btn-primary-soft py-1 px-2 mr-2">Izmeni</a>
                            <form action="{{route('players.destroy', ['player' => $player])}}" method="POST">
                                @csrf
                                <button class="btn btn-danger-soft py-1 px-2">Obriši</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
    @endforeach
    <!-- BEGIN: Users Layout -->
    </div>
@endsection
