@extends('../layouts/side-menu')

@section('subhead')
    <title>Kreiranje Tima - Fairplay</title>
@endsection

@section('subcontent')
    <div class="intro-y flex items-center mt-8">
        <h2 class="text-lg font-medium mr-auto">Kreiranje Tima</h2>
    </div>
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 lg:col-span-6">
            <form action="{{route('teams.store')}}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- BEGIN: Form Layout -->
                <div class="intro-y box p-5">
                    <div>
                        <label for="crud-form-1" class="form-label">Ime</label>
                        <input name="name" id="crud-form-1" type="text" class="form-control w-full"
                               placeholder="Unesite ime">
                    </div>

                    <div class="mt-3">
                        <label for="crud-form-2" class="form-label">Opis</label>
                        <input name="description" id="crud-form-2" type="text" class="form-control w-full"
                               placeholder="Unesite opis">
                    </div>


                    <div class="mt-3">
                        <label for="crud-form-3" class="form-label">Trener</label>
                        <div class="input-group mt-2 sm:mt-0 col-span-2">
                            <select data-placeholder="Izaberi trenera" class="tom-select w-full"
                                    name="coach_id" id="crud-form-3">
                                @foreach($coaches as $coach)
                                    <option value="{{$coach->id}}">{{$coach->fullName()}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="text-right mt-5">
                        <button type="submit" class="btn btn-primary w-24">Kreiraj</button>
                    </div>
                </div>
                <!-- END: Form Layout -->
            </form>
        </div>
    </div>
@endsection
