@extends('../layouts/side-menu')

@section('subhead')
    <title>Kreiranje Administratora - Fairplay</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-6 mt-5">
        <!-- BEGIN: Register Form -->
        <div class="intro-y col-span-8 lg:col-span-10">
            <div class="intro-y box p-5">
                <form method="POST" action="{{ route('admins.store')}}">
                    <div class="col-span-5">
                        @csrf
                        <div class="mt-5">
                            <label for="roles" class="form-label">Uloga</label>
                            <select name="role" id="roles" class="tom-select w-full">
                                @foreach ($roles as $role)
                                    <option value="{{$role->name}}">{{$role->name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-span-5">
                            <div class="mt-5">
                                <label for="crud-form-1" class="form-label">Ime</label>
                                <input id="crud-form-1" type="text" name="first_name"
                                       class="form-control" maxlength="100" value="{{old('first_name')}}"
                                       placeholder="Unesite Ime">
                            </div>
                            <div class="mt-5">
                                <label for="crud-form-2" class="form-label">Prezime</label>
                                <input id="crud-form-2" type="text" name="last_name"
                                       class="form-control" maxlength="100" value="{{old('last_name')}}"
                                       placeholder="Unesite Prezime">
                            </div>
                            <div class="mt-5">
                                <label for="crud-form-3" class="form-label">E-mail Adresa</label>
                                <input id="crud-form-3" type="text" name="email"
                                       class="form-control" maxlength="100" value="{{old('email')}}"
                                       placeholder="Unesite E-mail Adresu">
                            </div>
                            <div class="mt-5">
                                <label for="crud-form-4" class="form-label">Lozinka</label>
                                <input id="crud-form-4" type="password" name="password"
                                       class="form-control" maxlength="100"
                                       placeholder="Unesite Lozinku">

                            </div>
                            <div class="mt-5">
                                <label for="crud-form-5" class="form-label">Ponovljena lozinka</label>
                                <input id="crud-form-5" type="password" name="password_confirmation" maxlength="100"
                                       class="intro-x login__input form-control py-3 px-4 border-gray-300 block mt-4"
                                       placeholder="Unesite Ponovljenu Lozinku">

                            </div>
                        </div>
                    </div>
                    <div class="intro-x mt-5 xl:mt-8 text-center xl:text-left">
                        <button class="btn btn-primary py-3 px-4 w-full xl:w-32 xl:mr-3 align-top">Dodaj</button>

                    </div>
                </form>
            </div>
        </div>
        <!-- END: Register Form -->
    </div>
@endsection
