@extends('../layouts/side-menu')

@section('subhead')
    <title>Izmena Administratora - Fairplay</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12">
            <!-- BEGIN: Form Layout -->
            <form action="{{route('admins.update', ['admin' => $admin->id])}}" method="POST"
                  enctype="multipart/form-data">
                @csrf
                {{ method_field('patch') }}
                <div class="intro-y box p-5">
                    <div class="mt-3">
                        <div class="">
                            <label for="crud-form-1" class="form-label">Ime</label>
                            <input id="crud-form-1" type="text" name="first_name" class="form-control"
                                   placeholder="Enter first name" value="{{$admin->first_name}}" autofocus
                                   required>
                        </div>

                        <div class="mt-5">
                            <label for="crud-form-2" class="form-label">Prezime</label>
                            <input id="crud-form-2" type="text" name="last_name" class="form-control"
                                   placeholder="Enter last name" value="{{$admin->last_name}}" autofocus required>
                        </div>

                        <div class="mt-5">
                            <label for="crud-form-5" class="form-label">E-mail Adresa</label>
                            <input id="crud-form-5" type="email" name="email" class="form-control"
                                   placeholder="Enter email address" value="{{$admin->email}}" autofocus required>
                        </div>
                    </div>
                    <div class="text-right mt-5">
                        <button class="btn btn-primary w-30"><i data-feather="save" class="sm block mr-1 mx-auto"></i>Izmeni
                        </button>
                    </div>
                </div>
            </form>
            <!-- END: Form Layout -->
        </div>
    </div>
@endsection
