@extends('../layouts/side-menu')

@section('subhead')
    <title>Administratori - Fairplay</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 flex flex-wrap sm:flex-nowrap items-center mt-2">
            <div class="hidden md:block mx-auto text-gray-600"></div>
            <div class="w-full sm:w-auto flex mt-4 sm:mt-0">
                <a href="{{route('admins.create')}}" class="btn btn-primary shadow-md mr-2">Dodaj Novog Administratora</a>
            </div>
        </div>
        <!-- BEGIN: Users Layout -->
        @foreach ($admins as $key => $admin)
            <div class="intro-y col-span-12 md:col-span-6">
                <div class="box">
                    <div class="flex flex-col lg:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                        <div class="w-24 h-24 lg:w-12 lg:h-12 image-fit lg:mr-1">
                            <img alt="Tinker Tailwind HTML Admin Template" class="rounded-full"
                                 src="{{ asset('dist/images/' . $fakers[0]['photos'][0]) }}">
                        </div>
                        <div class="lg:ml-2 lg:mr-auto text-center lg:text-left mt-3 lg:mt-0">
                            <a href="" class="font-medium">{{ $admin->fullName() }}</a>
                            <div class="text-gray-600 text-xs mt-0.5">{{ $admin->getRoleNames()->first() }}</div>
                        </div>
                        <div class="flex -ml-2 lg:ml-0 lg:justify-end mt-3 lg:mt-0">
                            <div class="absolute right-0 top-0 mr-5 mt-3 dropdown">
                                <a class="dropdown-toggle w-5 h-5 block" href="javascript:;" aria-expanded="false">
                                    <i data-feather="more-horizontal" class="w-5 h-5 text-gray-600 dark:text-gray-300"></i>
                                </a>
                                <div class="dropdown-menu w-40">
                                    <div class="dropdown-menu__content box dark:bg-dark-1 p-2">
                                        <a href="{{route('admins.edit', ['admin' => $admin])}}" class="flex items-center block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2 rounded-md">
                                            <i data-feather="edit-2" class="w-4 h-4 mr-2"></i> Izmeni Admina
                                        </a>
                                        <form action="{{route('admins.destroy', ['admin' => $admin])}}" method="POST" enctype="multipart/form-data">
                                            @csrf
                                            <button class="flex items-center block p-2 transition duration-300 ease-in-out bg-white dark:bg-dark-1 hover:bg-gray-200 dark:hover:bg-dark-2 rounded-md">
                                                <i data-feather="trash" class="w-4 h-4 mr-2"></i> Izbriši Admina
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex flex-wrap lg:flex-nowrap items-center justify-center p-5">
                        <div class="w-full lg:w-1/2 mb-4 lg:mb-0 mr-auto"></div>
                        <button class="btn btn-primary py-1 px-2 mr-2">Poruka</button>
                    </div>
                </div>
            </div>
    @endforeach
    <!-- END: Users Layout -->
    </div>
@endsection
