@extends('../layouts/' . $layout)

@section('subhead')
    <title>Klubovi - Fairplay</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 flex flex-wrap sm:flex-nowrap items-center mt-2">
            {{--            <button class="btn btn-primary shadow-md mr-2">Add New Product</button>--}}

            <div class="hidden md:block mx-auto text-gray-600"></div>
            <div class="w-full sm:w-auto mt-3 sm:mt-0 sm:ml-auto md:ml-0">
                <div class="w-56 relative text-gray-700 dark:text-gray-300">
                    <input type="text" class="form-control w-56 box pr-10 placeholder-theme-13"
                           placeholder="Pretraga...">
                    <i class="w-4 h-4 absolute my-auto inset-y-0 mr-3 right-0" data-feather="search"></i>
                </div>
            </div>
        </div>
        <!-- BEGIN: Data List -->
        <div class="intro-y col-span-12 overflow-auto lg:overflow-visible">
            <table class="table table-report -mt-2">
                <thead>
                <tr>
                    <th class="whitespace-nowrap">Slika</th>
                    <th class="whitespace-nowrap">IME</th>
                    <th class="text-center whitespace-nowrap">WEBSITE</th>
                    <th class="text-center whitespace-nowrap">E-MAIL ADRESA</th>
                    <th class="text-center whitespace-nowrap">TELEFON</th>
                    <th class="text-center whitespace-nowrap">STATUS</th>
                    <th class="text-center whitespace-nowrap">AKCIJE</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($clubs as $club)
                    <tr class="intro-x">
                        <td class="w-20">
                            <div class="flex">
                                <div class="w-10 h-10 image-fit zoom-in">
                                    <img @if($club->logo == 'default.png')
                                         src="{{asset('storage/images/clubs/'.$club->logo)}}"
                                         @else
                                         src="{{asset('storage/images/clubs/'.$club->id.'/'.$club->logo)}}"
                                         @endif id="imageInput" alt="Logo Kluba">
                                </div>
                            </div>
                        </td>
                        <td>
                            <a href="" class="font-medium whitespace-nowrap">{{ $club->name }}</a>
                            {{--                            <div class="text-gray-600 text-xs whitespace-nowrap mt-0.5">{{ $faker['products'][0]['category'] }}</div>--}}
                        </td>
                        <td class="text-center">{{ $club->website }}</td>
                        <td class="text-center">{{ $club->email }}</td>
                        <td class="text-center">{{ $club->phone }}</td>
                        <td class="text-center w-40">
                            @if(is_null($club->approved_at))
                                <form action="{{ route('clubs.approve', ['club' => $club]) }}" method="POST">
                                    @csrf
                                    <button class="btn btn-success">Odobri</button>
                                </form>
                            @else
                                <div
                                    class="flex items-center justify-center {{ $fakers[0]['true_false'][0] ? 'text-theme-20' : 'text-theme-21' }}">
                                    <i data-feather="check-square" class="w-4 h-4 mr-2"></i> ODOBREN
                                </div>
                            @endif
                        </td>
                        <td class="table-report__action w-56">
                            <div class="flex justify-center items-center">
                                <a href="{{route('clubs.edit', ['club' => $club])}}" class="flex items-center mr-3">
                                    <i data-feather="check-square" class="w-4 h-4 mr-1"></i> Izmeni
                                </a>
                                <form action="{{ route('clubs.destroy', ['club' => $club]) }}" method="POST">
                                    @csrf
                                    <button class="flex items-center text-theme-21">
                                        <i data-feather="trash-2" class="w-4 h-4 mr-1"></i> Izbriši
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
        <!-- END: Data List -->
    </div>
@endsection
