@extends('../layouts/' . $layout)

@section('subhead')
    <title>Takmičenja - Fairplay</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 flex flex-wrap sm:flex-nowrap items-center mt-2">

            <div class="hidden md:block mx-auto text-gray-600"></div>
{{--            <div class="w-full sm:w-auto mt-3 sm:mt-0 sm:ml-auto md:ml-0">--}}
{{--                <div class="w-56 relative text-gray-700 dark:text-gray-300">--}}
{{--                    <input type="text" class="form-control w-56 box pr-10 placeholder-theme-13"--}}
{{--                           placeholder="Pretraga...">--}}
{{--                    <i class="w-4 h-4 absolute my-auto inset-y-0 mr-3 right-0" data-feather="search"></i>--}}
{{--                </div>--}}
{{--            </div>--}}
            <div class="intro-y col-span-12 flex flex-wrap sm:flex-nowrap items-center mt-2">
                <div class="hidden md:block mx-auto text-gray-600"></div>
                <div class="w-full sm:w-auto flex mt-4 sm:mt-0">
                    <a href="{{route('competitions.create')}}" class="btn btn-primary shadow-md mr-2">Dodaj Novo Takmičenje</a>
                </div>
            </div>
        </div>
        <!-- BEGIN: Data List -->
        <div class="intro-y col-span-12 overflow-auto lg:overflow-visible">
            <table class="table table-report -mt-2">
                <thead>
                <tr>
                    <th class="whitespace-nowrap">IME</th>
                    <th class="text-center whitespace-nowrap">OPIS</th>
                    <th class="text-center whitespace-nowrap">POČETAK</th>
                    <th class="text-center whitespace-nowrap">AKCIJE</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($competitions as $competition)
                    <tr class="intro-x">
                        <td>
                            <a href="" class="font-medium whitespace-nowrap">{{ $competition->name }}</a>
                            {{--                            <div class="text-gray-600 text-xs whitespace-nowrap mt-0.5">{{ $faker['products'][0]['category'] }}</div>--}}
                        </td>
                        <td class="text-center">{{ $competition->description }}</td>
                        <td class="text-center">{{ $competition->starts_at }}</td>
                        <td class="table-report__action w-56">
                            <div class="flex justify-center items-center">
                                <a href="{{route('competitions.edit', ['competition' => $competition])}}" class="flex items-center mr-3">
                                    <i data-feather="check-square" class="w-4 h-4 mr-1"></i> Izmeni
                                </a>
                                <form action="{{ route('competitions.destroy', ['competition' => $competition]) }}" method="POST">
                                    @csrf
                                    <button class="flex items-center text-theme-21">
                                        <i data-feather="trash-2" class="w-4 h-4 mr-1"></i> Izbriši
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
        <!-- END: Data List -->
    </div>
@endsection
