@extends('../layouts/side-menu')

@section('subhead')
    <title>Izmena Vesti - Fairplay</title>
@endsection

@section('subcontent')
    <div class="intro-y flex items-center mt-8">
        <h2 class="text-lg font-medium mr-auto">Kreiranje vesti</h2>
    </div>
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 lg:col-span-12">
            <!-- BEGIN: Form Layout -->
            <div class="intro-y box p-5">
                <form action="{{route('news.update', ['news' => $news])}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    {{ method_field('patch') }}
                    <div class="grid grid-cols-2 gap-3">
                        <div>
                            <div>
                                <label for="crud-form-1" class="form-label">Naslov</label>
                                <input id="crud-form-1" name="title" type="text" class="form-control w-full"
                                       value="{{$news->title}}" placeholder="Unesite naslov">
                            </div>
                            <div class="mt-3">
                                <label for="crud-form-2" class="form-label">Kraći tekst</label>
                                <input value="{{$news->short_content}}" id="crud-form-2" name="short_content"
                                       type="text" class="form-control w-full" placeholder="Unesite kraći tekst">
                            </div>
                            <div class="mt-3">
                                <label for="crud-form-3" class="form-label">Tekst</label>
                                <textarea rows="5" value="{{$news->article_content}}" id="crud-form-3" name="article_content"
                                          type="text" class="form-control w-full" placeholder="Unesite tekst">
                                    {{$news->article_content}}
                                </textarea>
                            </div>
                        </div>

                        <div class="p-14">
                            <div>
                                <input id="imageFile" type="file" name="image" placeholder="Izaberite Sliku Vesti"
                                       hidden>
                                <img src="{{asset('storage/default/logo.png')}}" alt="" id="imageInput"
                                     style="cursor:pointer; object-fit: contain; height: 200px; width: 200px;">
                            </div>
                        </div>
                    </div>

                    {{--                    <div class="mt-3">--}}
                    {{--                        <label for="crud-form-4" class="form-label">Slike</label>--}}
                    {{--                        <input id="crud-form-4" type="file" name="images[]" placeholder="Choose images" multiple>--}}
                    {{--                    </div>--}}
                    {{--                    <div class="mt-3">--}}
                    {{--                        <div class="mt-1 text-center">--}}
                    {{--                            <div class="images-preview-div form-control w-full"--}}
                    {{--                                 style="background-color: white; height: 300px">--}}

                    {{--                            </div>--}}
                    {{--                        </div>--}}
                    {{--                    </div>--}}

                    <div class="text-right mt-5">
                        <button type="submit" class="btn btn-primary w-24">Objavi</button>
                    </div>
                </form>
            </div>
            <!-- END: Form Layout -->
        </div>
    </div>
@endsection
{{--@section('script')--}}
{{--    <script src="{{ asset('js/image-upload-with-preview.js') }}"></script>--}}
{{--@endsection--}}
@section('script')
    <script src="{{ asset('js/single-image-upload.js') }}"></script>
@endsection
