@extends('../layouts/side-menu')

@section('subhead')
    <title>Izmena Sponzora - Fairplay</title>
@endsection

@section('subcontent')
    <div class="intro-y flex items-center mt-8">
        <h2 class="text-lg font-medium mr-auto">Kreiranje Sponzora</h2>
    </div>
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 lg:col-span-6">
            <!-- BEGIN: Form Layout -->
            <div class="intro-y box p-5">
                <form action="{{route('sponsors.update', ['sponsor' => $sponsor])}}" method="POST"
                      enctype="multipart/form-data">
                    @csrf
                    {{ method_field('patch') }}
                    <div>
                        <label for="crud-form-1" class="form-label">Ime</label>
                        <input value="{{$sponsor->name}}" name="name" id="crud-form-1" type="text"
                               class="form-control w-full"
                               placeholder="Unesite ime">
                    </div>
                    <div class="mt-3">
                        <label for="crud-form-2" class="form-label">Category</label>
                        <input value="{{$sponsor->description}}" name="description" id="crud-form-2" type="text"
                               class="form-control w-full"
                               placeholder="Unesite opis">

                    </div>
                    <div class="mt-3">
                        <input id="imageFile" type="file" name="logo" hidden>
                        <img @if($sponsor->logo == 'default.png')
                             src="{{asset('storage/images/clubs/'.$sponsor->logo)}}"
                             @else
                             src="{{asset('storage/images/sponsors/'.$sponsor->id.'/'.$sponsor->logo)}}"
                             @endif id="imageInput" alt="Logo Kluba"
                             style="cursor:pointer; object-fit: contain; height: 200px; width: 200px;">
                    </div>
                    <div class="mt-3">

                        <div class="text-right mt-5">
                            <button type="submit" class="btn btn-primary w-24">Izmeni</button>
                        </div>
                    </div>
                    <!-- END: Form Layout -->
                </form>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script src="{{ asset('js/single-image-upload.js') }}"></script>
@endsection
