@extends('../layouts/main')

@section('head')
    @yield('subhead')
@endsection

@section('content')
    @include('../layouts/components/mobile-menu')
    <!-- BEGIN: Top Bar -->
    <div class="top-bar-boxed border-b border-theme-3 px-4 md:px-6 mb-14 md:mb-8">
        <div class="h-full flex items-center">
            <!-- BEGIN: Logo -->
            <a href="{{route('dashboard')}}" class="-intro-x hidden md:flex">
                <img alt="Tinker Tailwind HTML Admin Template" class="w-6" src="{{ asset('dist/images/logo.svg') }}">
                <span class="text-white text-lg ml-3">
                    Fair<span class="font-medium">play</span>
                </span>
            </a>
            <!-- END: Logo -->
            <!-- BEGIN: Breadcrumb -->
            <div class="-intro-x breadcrumb breadcrumb--light mr-auto">
                <a href="">Fairplay</a>
                <i data-feather="chevron-right" class="breadcrumb__icon"></i>
                <a href="" class="breadcrumb--active">Dashboard</a>
            </div>
            <!-- END: Breadcrumb -->

        {{--            <!-- BEGIN: Notifications -->--}}
        {{--            <div class="intro-x dropdown mr-4 sm:mr-6">--}}
        {{--                <div class="dropdown-toggle notification notification--light notification--bullet cursor-pointer"--}}
        {{--                     role="button" aria-expanded="false">--}}
        {{--                    <i data-feather="bell" class="notification__icon dark:text-gray-300"></i>--}}
        {{--                </div>--}}
        {{--                <div class="notification-content pt-2 dropdown-menu">--}}
        {{--                    <div class="notification-content__box dropdown-menu__content box dark:bg-dark-6">--}}
        {{--                        <div class="notification-content__title">Notifications</div>--}}
        {{--                        @foreach (array_slice($fakers, 0, 5) as $key => $faker)--}}
        {{--                            <div class="cursor-pointer relative flex items-center {{ $key ? 'mt-5' : '' }}">--}}
        {{--                                <div class="w-12 h-12 flex-none image-fit mr-1">--}}
        {{--                                    <img alt="Tinker Tailwind HTML Admin Template" class="rounded-full"--}}
        {{--                                         src="{{ asset('dist/images/' . $faker['photos'][0]) }}">--}}
        {{--                                    <div--}}
        {{--                                        class="w-3 h-3 bg-theme-20 absolute right-0 bottom-0 rounded-full border-2 border-white"></div>--}}
        {{--                                </div>--}}
        {{--                                <div class="ml-2 overflow-hidden">--}}
        {{--                                    <div class="flex items-center">--}}
        {{--                                        <a href="javascript:;"--}}
        {{--                                           class="font-medium truncate mr-5">{{ $faker['users'][0]['name'] }}</a>--}}
        {{--                                        <div--}}
        {{--                                            class="text-xs text-gray-500 ml-auto whitespace-nowrap">{{ $faker['times'][0] }}</div>--}}
        {{--                                    </div>--}}
        {{--                                    <div--}}
        {{--                                        class="w-full truncate text-gray-600 mt-0.5">{{ $faker['news'][0]['short_content'] }}</div>--}}
        {{--                                </div>--}}
        {{--                            </div>--}}
        {{--                        @endforeach--}}
        {{--                    </div>--}}
        {{--                </div>--}}
        {{--            </div>--}}
        {{--            <!-- END: Notifications -->--}}
        <!-- BEGIN: Account Menu -->
            <div class="intro-x dropdown w-8 h-8">
                <div class="dropdown-toggle w-8 h-8 rounded-full overflow-hidden shadow-lg image-fit zoom-in"
                     role="button" aria-expanded="false">
                    <img alt="Tinker Tailwind HTML Admin Template"
                         src="{{ asset('dist/images/' . $fakers[9]['photos'][0]) }}">
                </div>
                <div class="dropdown-menu w-56">
                    <div class="dropdown-menu__content box dark:bg-dark-6">
                        <div class="p-4 border-b border-black border-opacity-5 dark:border-dark-3">
                            <div class="font-medium">{{\Illuminate\Support\Facades\Auth::user()->fullName()}}</div>
                            <div
                                class="text-xs text-gray-600 mt-0.5 dark:text-gray-600">{{ \Illuminate\Support\Facades\Auth::user()->roles[0]->display_name}}</div>
                        </div>
                        <div class="p-2">
                            <a href="{{route('admins.show')}}"
                               class="flex items-center block p-2 transition duration-300 ease-in-out hover:bg-gray-200 dark:hover:bg-dark-3 rounded-md">
                                <i data-feather="user" class="w-4 h-4 mr-2"></i> Profil
                            </a>
                            {{--                            <a href=""--}}
                            {{--                               class="flex items-center block p-2 transition duration-300 ease-in-out hover:bg-gray-200 dark:hover:bg-dark-3 rounded-md">--}}
                            {{--                                <i data-feather="edit" class="w-4 h-4 mr-2"></i> Dodaj novi profil--}}
                            {{--                            </a>--}}
                            <a href="{{route('password.change')}}"
                               class="flex items-center block p-2 transition duration-300 ease-in-out hover:bg-theme-1 dark:hover:bg-dark-3 rounded-md">
                                <i data-feather="unlock" class="w-4 h-4 mr-2"></i> Reset Password
                            </a>
                            <a href=""
                               class="flex items-center block p-2 transition duration-300 ease-in-out hover:bg-gray-200 dark:hover:bg-dark-3 rounded-md">
                                <i data-feather="help-circle" class="w-4 h-4 mr-2"></i> Pomoć
                            </a>
                        </div>
                        <div class="p-2 border-t border-theme-27 dark:border-dark-3">
                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <button class="w-52 flex items-center block p-2 transition duration-300 ease-in-out hover:bg-theme-1 dark:hover:bg-dark-3 rounded-md">
                                    <i data-feather="toggle-right" class="w-4 h-4 mr-2"></i> Odjava
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- END: Account Menu -->
        </div>
    </div>
    <!-- END: Top Bar -->
    <!-- BEGIN: Top Menu -->
    <nav class="top-nav">
        <ul>
            @foreach ($top_menu as $menuKey => $menu)
                <li>
                    <a href="{{ isset($menu['route_name']) ? route($menu['route_name'], $menu['params']) : 'javascript:;' }}"
                       class="{{ $first_level_active_index == $menuKey ? 'top-menu top-menu--active' : 'top-menu' }}">
                        <div class="top-menu__icon">
                            <i data-feather="{{ $menu['icon'] }}"></i>
                        </div>
                        <div class="top-menu__title">
                            {{ $menu['title'] }}
                            @if (isset($menu['sub_menu']))
                                <i data-feather="chevron-down" class="top-menu__sub-icon"></i>
                            @endif
                        </div>
                    </a>
                    @if (isset($menu['sub_menu']))
                        <ul class="{{ $first_level_active_index == $menuKey ? 'top-menu__sub-open' : '' }}">
                            @foreach ($menu['sub_menu'] as $subMenuKey => $subMenu)
                                <li>
                                    <a href="{{ isset($subMenu['route_name']) ? route($subMenu['route_name'], $subMenu['params']) : 'javascript:;' }}"
                                       class="top-menu">
                                        <div class="top-menu__icon">
                                            <i data-feather="activity"></i>
                                        </div>
                                        <div class="top-menu__title">
                                            {{ $subMenu['title'] }}
                                            @if (isset($subMenu['sub_menu']))
                                                <i data-feather="chevron-down" class="top-menu__sub-icon"></i>
                                            @endif
                                        </div>
                                    </a>
                                    @if (isset($subMenu['sub_menu']))
                                        <ul class="{{ $second_level_active_index == $subMenuKey ? 'top-menu__sub-open' : '' }}">
                                            @foreach ($subMenu['sub_menu'] as $lastSubMenuKey => $lastSubMenu)
                                                <li>
                                                    <a href="{{ isset($lastSubMenu['route_name']) ? route($lastSubMenu['route_name'], $lastSubMenu['params']) : 'javascript:;' }}"
                                                       class="top-menu">
                                                        <div class="top-menu__icon">
                                                            <i data-feather="zap"></i>
                                                        </div>
                                                        <div class="top-menu__title">{{ $lastSubMenu['title'] }}</div>
                                                    </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </li>
                            @endforeach
                        </ul>
                    @endif
                </li>
            @endforeach
        </ul>
    </nav>
    <!-- END: Top Menu -->
    <!-- BEGIN: Content -->
    <div class="content content--top-nav @yield('content-modifier')">
        @yield('subcontent')
    </div>
    <!-- END: Content -->
@endsection
