@extends('../layouts/' . $layout)

@section('subhead')
    <title>Wysiwyg Editor - Tinker - Tailwind HTML Admin Template</title>
@endsection

@section('subcontent')
    <div class="flex items-center mt-8">
        <h2 class="text-lg font-medium mr-auto">CKEditor</h2>
    </div>
    <div class="grid grid-cols-12 gap-6 mt-5">
        <!-- BEGIN: Inline Editor -->
        <div class="col-span-12">
            <div class="box">
                <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                    <h2 class="font-medium text-base mr-auto">Inline Editor</h2>
                    <div class="w-full sm:w-auto flex items-center sm:ml-auto mt-3 sm:mt-0">
                        <label class="form-check-label ml-0 sm:ml-2" for="show-example-5">Show example code</label>
                        <input data-target="#inline-editor" class="show-code form-check-switch mr-0 ml-3" type="checkbox" id="show-example-5">
                    </div>
                </div>
                <div class="p-5" id="inline-editor">
                    <div class="preview">
                        <div class="editor">
                            <p>Content of the editor.</p>
                        </div>
                    </div>
                    <div class="source-code hidden">
                        <button data-target="#copy-inline-editor" class="copy-code btn py-1 px-2 btn-outline-secondary">
                            <i data-feather="file" class="w-4 h-4 mr-2"></i> Copy example code
                        </button>
                        <div class="overflow-y-auto mt-3 rounded-md">
                            <pre class="source-preview" id="copy-inline-editor">
                                <code class="javascript text-xs p-0 rounded-md html pl-5 pt-8 pb-4 -mb-10 -mt-10">
                                    {{ \Hp::formatCode('
                                        import InlineEditor from "@ckeditor/ckeditor5-build-inline";

                                        cash(".editor").each(function () {
                                            const el = this;
                                            InlineEditor.create(el).catch((error) => {
                                                console.error(error);
                                            });
                                        });
                                    ') }}
                                </code>
                            </pre>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- END: Inline Editor -->
    </div>
@endsection

@section('script')
    <script src="{{ mix('dist/js/ckeditor-inline.js') }}"></script>
@endsection
