@extends('website/layout')

@section('title')
    O Nama
@endsection

@section('content')
    <!--Main Slider Start-->
    <div class="inner-banner-header wf100" style="background: url({{asset('../resources/images/website/about.jpg')}}) no-repeat; background-size: cover;">
        <h1 data-generated="O Nama" class="news-all-title">O Nama</h1>
        <div class="gt-breadcrumbs">
            <ul>
                <li> <a href="{{route('website.home.index')}}" > <i class="fas fa-home"></i> Početna </a> </li>
                <li> <a href="{{route('website.about')}}" class="active"> <i class="fas fa-users"></i> O Nama </a> </li>
            </ul>
        </div>
    </div>
    <!--Main Slider End-->
    <!--Main Content Start-->
    <div class="container">
        <div class="section-title" style="margin-top: 30px;">
            <h2>O Nama</h2>
        </div>
        <div>
            U septembru 2005.godine, na stadionu FK IM Rakovica, odigrane su utakmice 1.kola Fair Play Lige, prvog dečijeg fudbalskog takmičenja na otvorenim terenima u Srbiji. U prvoj takmičarskoj sezoni učestvovalo je 48 ekipa u četiri starosne generacije sa više od 700 fudbalera. Nakon četiri takmičarske sezone FPL je postala najmasovnija liga za decu na otvorenim terenima u Srbiji. Značajno priznanje usledilo je 2009.godine, i to od najrelavantnije ustanove za razvoj fudbala – Fudbalskog saveza Srbije, koji je uvrstio Fair Play ligu u zvaničan kalendar aktivnosti sektora za bazični fudbal. Fair Play Liga deceniju za nama predstavlja sinonim za takmičenje u kome sportski rezultat nije najvažniji cilj, već afirmacija fer-plej ponašanja. Drugim rečima, cilj FPL je da stvori ne samo uspešne sportiste, već i dobre i kvalitetne ljude.

            “Fer-plej ne označava samo poštovanje dogovorenih pravila igre, već i u širem smislu obuhvata držanje sportiste: poštovanje protivnika i očuvanje psihičkog i fizičkog dostojanstva. Onaj sportista koji se može staviti u poziciju svog protivnika ponaša se fer.” (Izvod iz Deklaracije Internacionalnog komiteta za Fair- Play).
        </div>
        <div class="section-title" style="margin-top: 30px;">
            <h2>Ideja i Misija</h2>
        </div>
        <div>
            Srpski sport podelio je, u poslednjih petnaest godina za nama, sudbinu zemalja kojim je pripadao – prošao je kroz doba posrtanja i zabrinjavajućih kriza. Kriza nije dotakla samo vrh piramide koju kreira profesionalni, odnosno vrhunski sport, već je prožela sve njegove delove, pa i dečiji. Jedna od posledica je da su iz sporta u značajnoj meri otrgnute njegove najplemenitije karakteristike, vrednosti koje su ga izdigle iznad zabave i iznad igre, etablirajući ga kao možda i najveći globalni fenomen naše ere, vrednosti Fair Play-a!

            Grupa mladih sportskih trenera, pedagoga i profesora, koji su kao prioritet u svom delovanju izabrali rad sa decom od 5 do 15 godina starosti, okupila se 2005.godine, oko ideje da je najmlađim članovima našeg društva, koji odrastaju u surovim vremenima u kojima se malo pažnje pridaje njihovom zdravom i bezbrižnom odrastanju i adekvatnom vaspitavanju, od malena potrebno usaditi naviku o neophodnosti poštenog odnosa prema drugaru, nastavniku, sportskom rivalu, treneru, gledaocu. Smatrajući da će te navike, ako se u pravo vreme i na pravi način uspostave, ostati u dečijoj svesti zauvek, bavili se oni sportom ili ne. A upravo je sport tu da u tome pomogne! Tako je osnovana Dečija sportska Fer plej asocijacija (DSFA), koja je, čitavu deceniju na autentičan način kroz razne akcije promovisala ideju iz koje je iznikla da sportski rezultat nije primarni i jedini cilj sportskih takmičenja već je akcenat na afirmaciji fer plej ponašanja na terenu i tribinama. Time se DSFA, edukujući najmlađe kroz svoje aktivnosti, priključila sve širem frontu borbe protiv nasilja i nedoličnog ponašanja na sportskim priredbama, koje predvodi Ministarstvo omladine i sporta Republike Srbije.

            Nakon decenije uspešnog rada i organizacije više od stotinu sportskih događaja, nekoliko desetina humanitarnih i edukativnih akcija u kojima je učestvovalo više od 30.000 dece, ukazala se potreba da se ideja promocije etičkih sportskih vrednosti proširi na starije populacije i to na čitavoj teritoriji Srbije. Tako je na inicijativu nekoliko sportskih klubova, članova DSFA, krajem 2015.godine osnovan Srpski savez za fer plej i etiku u sportu (SSFES).
        </div>
    </div>
    <!--Main Content End-->
    <!--Sponsor Logos Start-->
    <section class="sponsor-logos wf100">
        <div class="container">
            <ul class="row">
                @foreach($sponsors as $sponsor)
                    <li class="col-md-2 col-4 col-sm-2"> <a target="_blank" href="{{$sponsor->description}}"><img src="{{asset('storage/images/sponsors/' . $sponsor->id . '/' . $sponsor->logo)}}" alt=""></a> </li>
                @endforeach
            </ul>
        </div>
    </section>
    <!--Sponsor Logos End-->
@endsection
