

<?php $__env->startSection('subhead'); ?>
    <title>Klubovi - Fairplay</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('subcontent'); ?>
    <div class="grid grid-cols-12 gap-6 mt-5">
        <div class="intro-y col-span-12 flex flex-wrap sm:flex-nowrap items-center mt-2">
            

            <div class="hidden md:block mx-auto text-gray-600"></div>
            <div class="w-full sm:w-auto mt-3 sm:mt-0 sm:ml-auto md:ml-0">
                <div class="w-56 relative text-gray-700 dark:text-gray-300">
                    <input type="text" class="form-control w-56 box pr-10 placeholder-theme-13"
                           placeholder="Pretraga...">
                    <i class="w-4 h-4 absolute my-auto inset-y-0 mr-3 right-0" data-feather="search"></i>
                </div>
            </div>
        </div>
        <!-- BEGIN: Data List -->
        <div class="intro-y col-span-12 overflow-auto lg:overflow-visible">
            <table class="table table-report -mt-2">
                <thead>
                <tr>
                    <th class="whitespace-nowrap">Slika</th>
                    <th class="whitespace-nowrap">IME</th>
                    <th class="text-center whitespace-nowrap">WEBSITE</th>
                    <th class="text-center whitespace-nowrap">E-MAIL ADRESA</th>
                    <th class="text-center whitespace-nowrap">TELEFON</th>
                    <th class="text-center whitespace-nowrap">STATUS</th>
                    <th class="text-center whitespace-nowrap">AKCIJE</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $clubs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $club): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="intro-x">
                        <td class="w-20">
                            <div class="flex">
                                <div class="w-10 h-10 image-fit zoom-in">
                                    <img alt="Tinker Tailwind HTML Admin Template" class="tooltip rounded-full"
                                         src="<?php echo e(asset('dist/images/' . $fakers[0]['images'][0])); ?>"
                                         title="Uploaded at <?php echo e($fakers[0]['dates'][0]); ?>">
                                </div>
                            </div>
                        </td>
                        <td>
                            <a href="" class="font-medium whitespace-nowrap"><?php echo e($club->name); ?></a>
                            
                        </td>
                        <td class="text-center"><?php echo e($club->website); ?></td>
                        <td class="text-center"><?php echo e($club->email); ?></td>
                        <td class="text-center"><?php echo e($club->phone); ?></td>
                        <td class="text-center w-40">
                            <?php if(is_null($club->approved_at)): ?>
                                <form action="<?php echo e(route('clubs.approve', ['club' => $club])); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button class="btn btn-success">Odobri</button>
                                </form>
                            <?php else: ?>
                                <div
                                    class="flex items-center justify-center <?php echo e($fakers[0]['true_false'][0] ? 'text-theme-20' : 'text-theme-21'); ?>">
                                    <i data-feather="check-square" class="w-4 h-4 mr-2"></i> ODOBREN
                                </div>
                            <?php endif; ?>
                        </td>
                        <td class="table-report__action w-56">
                            <div class="flex justify-center items-center">
                                <a class="flex items-center mr-3" href="javascript:;">
                                    <i data-feather="check-square" class="w-4 h-4 mr-1"></i> Izmeni
                                </a>
                                <form action="<?php echo e(route('clubs.destroy', ['club' => $club])); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button class="flex items-center text-theme-21">
                                        <i data-feather="trash-2" class="w-4 h-4 mr-1"></i> Izbriši
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <!-- END: Data List -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../layouts/' . $layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\php_fairplay\resources\views/backoffice/superadmin/clubs/index.blade.php ENDPATH**/ ?>