

<?php $__env->startSection('head'); ?>
    <title>Prijavljivanje - Fairplay</title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container sm:px-10">
        <div class="block xl:grid grid-cols-2 gap-4">
            <!-- BEGIN: Login Info -->
            <div class="hidden xl:flex flex-col min-h-screen">
                <a href="" class="-intro-x flex items-center pt-5">
                    <img alt="Tinker Tailwind HTML Admin Template" class="w-6"
                         src="<?php echo e(asset('dist/images/logo.svg')); ?>">
                    <span class="text-white text-lg ml-3">
                        Fair<span class="font-medium">play</span>
                    </span>
                </a>
                <div class="my-auto">
                    <img alt="Tinker Tailwind HTML Admin Template" class="-intro-x w-1/2 -mt-16"
                         src="<?php echo e(asset('dist/images/illustration.svg')); ?>">
                    <div class="-intro-x text-white font-medium text-4xl leading-tight mt-10">A few more clicks to <br>
                        sign in to your account.
                    </div>
                    <div class="-intro-x mt-5 text-lg text-white text-opacity-70 dark:text-gray-500">Manage all your
                        e-commerce accounts in one place
                    </div>
                </div>
            </div>
            <!-- END: Login Info -->
            <!-- BEGIN: Login Form -->
            <div class="h-screen xl:h-auto flex py-5 xl:py-0 my-10 xl:my-0">
                <div
                    class="my-auto mx-auto xl:ml-20 bg-white dark:bg-dark-1 xl:bg-transparent px-5 sm:px-8 py-8 xl:p-0 rounded-md shadow-md xl:shadow-none w-full sm:w-3/4 lg:w-2/4 xl:w-auto">
                    <h2 class="intro-x font-bold text-2xl xl:text-3xl text-center xl:text-left">Prijavljivanje</h2>
                    <div class="intro-x mt-2 text-gray-500 xl:hidden text-center">A few more clicks to sign in to your
                        account. Manage all your e-commerce accounts in one place
                    </div>
                    <div class="intro-x mt-8">
                        <form method="POST" action="<?php echo e(route('login.post')); ?>">
                            <div class="intro-x mt-8">
                                <?php echo csrf_field(); ?>
                                <input id="email" name="email" type="text"
                                       class="intro-x login__input form-control py-3 px-4 border-gray-300 block"
                                       placeholder="E-mail adresa" value="">
                                <div id="error-email" class="login__input-error w-5/6 text-theme-6 mt-2"></div>
                                <input id="password" name="password" type="password"
                                       class="intro-x login__input form-control py-3 px-4 border-gray-300 block mt-4"
                                       placeholder="Lozinka" value="">
                                <div id="error-password" class="login__input-error w-5/6 text-theme-6 mt-2"></div>
                            </div>
                            <div class="intro-x flex text-gray-700 dark:text-gray-600 text-xs sm:text-sm mt-4">
                                <div class="flex items-center mr-auto">
                                    <input id="remember-me" type="checkbox" class="form-check-input border mr-2">
                                    <label class="cursor-pointer select-none" for="remember-me">Zapamti me</label>
                                </div>
                            <?php if(Route::has('password.request')): ?>
                                <!--                                <a class="underline text-sm text-gray-600 hover:text-gray-900"
                                   href="<?php echo e(route('password.request')); ?>">
                                    <?php echo e(__('Forgot your password?')); ?>

                                    </a>-->
                                <?php endif; ?>
                            </div>
                            <div class="intro-x mt-5 xl:mt-8 text-center xl:text-left">
                                <button type="submit" id="btn-login"
                                        class="btn btn-primary py-3 px-4 w-full xl:w-32 xl:mr-3 align-top">
                                    Prijavi se
                                </button>
                                <a class="btn btn-outline-secondary py-3 px-4 w-full xl:w-32 mt-3 xl:mt-0 align-top"
                                   href="<?php echo e(url('/backoffice/register')); ?>">Register</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!-- END: Login Form -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        cash(function () {
            async function login() {
                // Reset state
                cash('#login-form').find('.login__input').removeClass('border-theme-21')
                cash('#login-form').find('.login__input-error').html('')

                // Post form
                let email = cash('#email').val()
                let password = cash('#password').val()
                let rememberMe = cash('#remember-me').val()

                // Loading state
                cash('#btn-login').html('<i data-loading-icon="oval" data-color="white" class="w-5 h-5 mx-auto"></i>').svgLoader()
                await helper.delay(1500)

                axios.post(`login`, {
                    email: email,
                    password: password,
                    remember_me: rememberMe
                }).then(res => {
                    location.href = '/'
                }).catch(err => {
                    cash('#btn-login').html('Login')
                    if (err.response.data.message != 'Wrong email or password.') {
                        for (const [key, val] of Object.entries(err.response.data.errors)) {
                            cash(`#${key}`).addClass('border-theme-21')
                            cash(`#error-${key}`).html(val)
                        }
                    } else {
                        cash(`#password`).addClass('border-theme-21')
                        cash(`#error-password`).html(err.response.data.message)
                    }
                })
            }

            cash('#login-form').on('keyup', function (e) {
                if (e.keyCode === 13) {
                    login()
                }
            })

            cash('#btn-login').on('click', function () {
                login()
            })
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../layouts/' . $layout, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\php_fairplay\resources\views/auth/login.blade.php ENDPATH**/ ?>